#!/bin/bash
#
# Copyright (c) 2006 Mellanox Technologies. All rights reserved.
#
# This Software is licensed under one of the following licenses:
#
# 1) under the terms of the "Common Public License 1.0" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/cpl.php.
#
# 2) under the terms of the "The BSD License" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/bsd-license.php.
#
# 3) under the terms of the "GNU General Public License (GPL) Version 2" a
#    copy of which is available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/gpl-license.php.
#
# Licensee has the right to choose one of the above licenses.
#
# Redistributions of source code must retain the above copyright
# notice and one of the license notices.
#
# Redistributions in binary form must reproduce both the above copyright
# notice, one of the license notices in the documentation
# and/or other materials provided with the distribution.
#
#
#  $Id: uninstall.sh 9433 2006-09-12 09:10:16Z vlad $
#
# Description: OFED package uninstall script

RPM=/bin/rpm
RM=/bin/rm
NULL=/dev/null

PACKAGE="OFED"
# Default ${PACKAGE} stack prefix

STACK_PREFIX=/usr/local/ofed

ARCH=$(uname -m)

IB_BASIC_PACKAGES="kernel-ib kernel-ib-devel libibverbs libibverbs-devel libibverbs-utils"
IB_BASIC_PACKAGES="$IB_BASIC_PACKAGES libibcm libibcm-devel libmthca libmthca-devel perftest mstflint"
IB_BASIC_PACKAGES="$IB_BASIC_PACKAGES libipathverbs libipathverbs-devel"
IB_BASIC_PACKAGES="$IB_BASIC_PACKAGES libehca libehca-devel"
IB_KERNEL_UTILS="oiscsi"

IB_ALL_PACKAGES="$IB_BASIC_PACKAGES"
IB_ALL_PACKAGES="$IB_ALL_PACKAGES libsdp srptools ipoibtools tvflash"
IB_ALL_PACKAGES="$IB_ALL_PACKAGES libibcommon libibcommon-devel libibmad libibmad-devel libibumad libibumad-devel opensm"
IB_ALL_PACKAGES="$IB_ALL_PACKAGES libopensm libopensm-devel libosmcomp libosmcomp-devel libosmvendor libosmvendor-devel"
IB_ALL_PACKAGES="$IB_ALL_PACKAGES librdmacm librdmacm-devel librdmacm-utils dapl dapl-devel"
IB_ALL_PACKAGES="$IB_ALL_PACKAGES openib-diags"

ALL_PACKAGES="${IB_ALL_PACKAGES} mpi_osu openmpi mpitests ibutils" #pdsh

PREV_RELEASE_PACKAGES="ibtsal openib opensm opensm-devel mpi_ncsa thca ib-osm osm diags ibadm ib-diags ibgdiag ibdiag ib-management"
PREV_RELEASE_PACKAGES="$PREV_RELEASE_PACKAGES ib-verbs ib-ipoib ib-cm ib-sdp ib-dapl udapl udapl-devel libdat libibat ib-kdapl ib-srp ib-srp_target oiscsi-iser-support ofed-docs ofed-scripts"

OPENMPI_NAME="openmpi"
MPI_OSU_NAME="mpi_osu"
MPI_OSU_MPICH_NAME="mpich_mlx"
PDSH_NAME="pdsh"


# Execute the command $@ and check exit status
ex()
{
echo Running $@
eval "$@"
if [ $? -ne 0 ]; then
     echo
     echo Failed in execution \"$@\"
     echo
     exit 5
fi
}


# Uninstall Software
uninstall()
{
    local RC=0
    local OLD_PREFIX=""
    echo
    echo "Removing ${PACKAGE} Software installations"
    echo

    OISCSI_LIST=$(rpm -qa | grep oiscsi)

    if [ -n "$OISCSI_LIST" ]; then
        for oiscsi_name in $OISCSI_LIST
        do 
            if ( $RPM -q ${oiscsi_name} > $NULL 2>&1 ); then
                ex "$RPM -e ${oiscsi_name}"
            fi
        done    
    fi

    MPITESTS_LIST=$(rpm -qa | grep mpitests)

    if [ -n "$MPITESTS_LIST" ]; then
        for mpitest_name in $MPITESTS_LIST
        do 
            if ( $RPM -q ${mpitest_name} > $NULL 2>&1 ); then
                ex "$RPM -e ${mpitest_name}"
            fi
        done    
    fi

   MPI_OSU_LIST=$(rpm -qa | grep ${MPI_OSU_MPICH_NAME})

    if [ -n "$MPI_OSU_LIST" ]; then
        for mpi_name in $MPI_OSU_LIST
        do 
            if ( $RPM -q ${mpi_name} > $NULL 2>&1 ); then
                ex "$RPM -e ${mpi_name}"
            fi
        done    
    fi

    OPENMPI_LIST=$(rpm -qa | grep ${OPENMPI_NAME})

    if [ -n "$OPENMPI_LIST" ]; then
        for mpi_name in $OPENMPI_LIST
        do 
            if ( $RPM -q ${mpi_name} > $NULL 2>&1 ); then
                ex "$RPM -e ${mpi_name}"
            fi
        done    
    fi

    if [[ ! -z $MTHOME && -d $MTHOME ]]; then
        if [ -e $MTHOME/uninstall.sh ]; then
            echo
            echo "  An old version of the OPENIB driver was detected and will be removed now"
            ex "yes | env MTHOME=$MTHOME $MTHOME/uninstall.sh"
        else
            echo
            echo "Found an MTHOME variable pointing to $MTHOME. Probably some old InfiniBand Software ..."
            echo
        fi    
        let RC++
    elif [ -d /usr/mellanox ]; then
        if [ -e /usr/mellanox/uninstall.sh ]; then
            echo
            echo "  Removing MVAPI..."
            ex "yes | /usr/mellanox/uninstall.sh"
        else
            echo
            echo "Found a /usr/mellanox directory. Probably some old InfiniBand Software ..."
            echo
        fi  
    fi
    
    packs_to_remove=""
    for package in $ALL_PACKAGES $PREV_RELEASE_PACKAGES $IB_KERNEL_UTILS
    do
        if ( $RPM -q ${package} > $NULL 2>&1 ); then
            packs_to_remove="$packs_to_remove ${package}"
            let RC++
        fi
    done    

    if ( $RPM -q ib-verbs > $NULL 2>&1 ); then
        OLD_PREFIX=`$RPM -ql ib-verbs | grep "utils/create_devs" | sed -e 's/\/utils\/create_devs//'`
        NEW_PREFIX=`$RPM -ql ib-verbs | grep "bin/ibv_devinfo" | sed -e 's/\/bin\/ibv_devinfo//'`
        let RC++
    fi    

    if ( $RPM -q libibverbs > $NULL 2>&1 ); then
        GEN2_PREFIX=$($RPM -ql libibverbs | grep "libibverbs.so" | head -1 | sed -e 's@/lib.*/libibverbs.so.*@@')            
    fi

    if [ -n "${packs_to_remove}" ]; then
        ex "$RPM -e $packs_to_remove"
    fi

    # Check if some empty directories with installation prefix still exist and remove them
    if [ -d ${STACK_PREFIX} ]; then
        find ${STACK_PREFIX} -type d | sort -r | xargs rmdir > $NULL 2>&1
    fi

    # rmdir ${STACK_PREFIX} > $NULL 2>&1

#    if [ -d $STACK_PREFIX ]; then
#            case ${STACK_PREFIX//\//} in
#                usr|bin|usrlocal|usrsbin|opt|root|home*|"")
#                ;;
#                *)
#                ex "$RM -rf $STACK_PREFIX"
#                ;;
#            esac
#    fi
#
#    if [ -d $OLD_PREFIX ]; then
#            case ${OLD_PREFIX//\//} in
#                usr|bin|usrlocal|usrsbin|opt|root|home*|"")
#                ;;
#                *)
#                ex "$RM -rf $OLD_PREFIX"
#                ;;
#            esac
#    fi
#
#    if [ -d $NEW_PREFIX ]; then
#            case ${NEW_PREFIX//\//} in
#                usr|bin|usrlocal|usrsbin|opt|root|home*|"")
#                ;;
#                *)
#                ex "$RM -rf $NEW_PREFIX"
#                ;;
#            esac
#    fi
#        
#    if [ -d $GEN2_PREFIX ]; then
#            case ${GEN2_PREFIX//\//} in
#                usr|bin|usrlocal|usrsbin|opt|root|home*|"")
#                ;;
#                *)
#                ex "$RM -rf $GEN2_PREFIX"
#                ;;
#            esac
#    fi

    # Uninstall SilverStorm package
    if [ -e /sbin/iba_config ]; then
        ex /sbin/iba_config -u
    fi

    # Uninstall Topspin package
    topspin_rpms=$($RPM -qa | grep "topspin-ib")
    if [ -n "${topspin_rpms}" ]; then
        ex $RPM -e ${topspin_rpms}
    fi

    # Uninstall Voltaire package
    voltaire_rpms=$($RPM -qa | grep -i "Voltaire" | grep "4.0.0_5")
    if [ -n "${voltaire_rpms}" ]; then
        ex $RPM -e ${voltaire_rpms}
    fi
}

echo
echo "This program will uninstall all IB packages on your machine."
echo

read -p "Do you want to continue?[y/N]:" ans_r
if [[ "$ans_r" == "y" || "$ans_r" == "Y" || "$ans_r" == "yes" ]]; then
    uninstall
else    
    exit 1
fi
